#version 330

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 normalMatrix;

layout (location = 0) in vec3 inPosition;
layout (location = 1) in vec2 inCoord;
layout (location = 2) in vec3 inNormal;

out vec2 TexCoord;
out vec3 Normal;

void main()
{
	gl_Position = projectionMatrix*modelViewMatrix*vec4(inPosition, 1.0);
	TexCoord = inCoord;
	vec4 vRes = normalMatrix*vec4(inNormal, 0.0);
	Normal = vRes.xyz;
}